/*===================================================================================
 copyright: (C) Copyright 2010 FileMaker, Inc. All Rights Reserved
 
 =================================================================================*/
function YUISupport(){
    /***** Slider methods *****************************************/
    
    // globals
    var slider;
    var topConstraint = 0;
    var bottomConstraint = 61;
    
	var duprec = 0;
	var omitcurr = 1;
	var omitmulti = 2;
	var showomit = 3;
	this.duprec = duprec;
	this.omitcurr = omitcurr;
    this.omitmulti = omitmulti;
	this.showomit = showomit;
	
	var dupreq = 0;
	var efind = 1;
    var cfind = 2;
    var revertreq = 3;
	this.dupreq = dupreq;
	this.efind = efind;
    this.cfind = cfind;
	this.revertreq = revertreq;
	
	var createfind = 0;
    var modifylastfind = 1;
	this.createfind = createfind;
    this.modifylastfind = modifylastfind;
	
	var allMenuItems = -1;
	this.allMenuItems = allMenuItems;
	
    var recMenuButton = new YAHOO.widget.Button({
		lazyloadmenu: false,
		type: "menu",
		label: "&nbsp&nbsp&nbsp&nbsp",
		id: "recMenuButton",
		title: top.iwp.strings.stat_hlp_rec,
		container: "recButton"
	});
	
	var reqMenuButton = new YAHOO.widget.Button({
		lazyloadmenu: false,
		type: "menu",
		label: "&nbsp&nbsp&nbsp&nbsp",
		id: "reqMenuButton",
		title: top.iwp.strings.stat_hlp_req,
		container: "reqButton"
    });
	
	var findMenuButton = new YAHOO.widget.Button({
		lazyloadmenu: false,
		type: "split",
		label: "&nbsp&nbsp&nbsp&nbsp",
		id: "findSplitButton",
		title: top.iwp.strings.stat_hlp_find,
		container: "findButton"
    });
		
	var viewButtonGroup = new YAHOO.widget.ButtonGroup({
        id: "viewButtonGroup",
        container: "viewbuttons",
        usearia: true
    });
	var omitButtonGroup = new YAHOO.widget.ButtonGroup({
        id: "omitButtonGroup",
        container: "omitFindControl",
        usearia: true
    });
	
	var include = 0;
	var omit = 1;   
	
	var formview = 0;
	var listview = 1;
	var tableview = 2;
	
	function getCurrentView()
	{
		var viewindex = -1;
		var viewas = top.iwp.bodyFrame.iwpinfo.viewas;
		
		switch(viewas)
		{
			case 'form':
				viewindex = formview;
				break;
			case 'list':
				viewindex = listview;
				break;
			case 'table':
				viewindex = tableview;
				break;
			default:
				break;
		}
		
		return viewindex;
	}	
	
	this.setMenuItemAccessibility = function setMenuItemAccessibility(menuButtonId, objIndex, disabled){
		
		if (menuButtonId != null && objIndex != null && disabled != null)
		{
			var menuButton;
			
			switch(menuButtonId)
			{
				case "recMenuButton":
					menuButton = recMenuButton;
					break;
				case "reqMenuButton":
					menuButton = reqMenuButton;
					break;
				case "findMenuButton":
					menuButton = findMenuButton;
				default:
					break;
			}
		
			if (menuButton != null)
			{
				if (objIndex > allMenuItems)
				{
					var buttonMenu = menuButton.getMenu();
					if (buttonMenu != null)
					{
						var item = buttonMenu.getItem(objIndex);
						if (item != null)
						{
							if (disabled)
								item.cfg.setProperty("disabled", true);
							else
								item.cfg.setProperty("disabled", false);
						}
					}
				}
				else
				{
					if (disabled)
						menuButton.set("disabled", true);
					else
						menuButton.set("disabled", false);
				}
			}
		}
	}
    
	function convertPixelToRecordNumber(pixelValue) {
		var rowValue = 0;
		var total = top.iwp.bodyFrame.iwpinfo.found;
		if (pixelValue == 0) 
			rowValue = 1;
		else 
		{
			if (pixelValue == bottomConstraint) {
				rowValue = total;
			}
			else {
				//this works based on percentages. 
				rowValue = Math.ceil((pixelValue / bottomConstraint) * total);
			}
		}
		
		return rowValue;
	}
		
	// Create and display the slider.
    this.showSlider = function showSlider(){
        
        
        slider = YAHOO.widget.Slider.getHorizSlider("slider", "slider-thumb", topConstraint, bottomConstraint, getTickSize());

		// When the slider moves, convert the pixel value to a row value
        slider.subscribe("slideEnd", function(){
            // get the slider's pixel value, calculate the actual row, reload page with selected record data
            var recNum = convertPixelToRecordNumber(this.getValue());
			top.iwp.goToRecordByNum(recNum);
        });
		
		slider.subscribe("change", function(pixelValue) {
			// get the slider's pixel value, calculate the actual row, change record number in input box
			var recNum = convertPixelToRecordNumber(pixelValue);
			top.iwp.changeRecordNumber(recNum);
		});
		
		slider.getThumb().on("mouseDownEvent", function(){
			return false;
		});
	}
    
    // Set the slider value to 'recNumField'. When the user enters a row value in the
    // recnumField box, set the slider to the appropriate value.
    this.setSliderValue = function setSliderValue(){
         slider.setValue(getOffsetSize(), true, true, true);
    }
	
	//Updates the slider ticks and max/min values.
	this.updateSlider = function updateSlider(){
		this.adjustSliderTickSize();
		this.setSliderValue();
	}
	
    //gets how much to move
    function getOffsetSize(){
        var sFrame = top.iwp.statusFrame;
		var offSetSize = 0;
        if (sFrame != null) {
            var obj = sFrame.document.getElementById('recnumField');
            if (obj != null) {
                var rowVal = parseInt(obj.value, 10);
                var total = top.iwp.bodyFrame.iwpinfo.found;
				if (total == 0){
					offSetSize = 0;
				} else if (rowVal <= 1) {
					offSetSize = 0;
				} else if ( rowVal == total){
					offSetSize = bottomConstraint - 1;
				}else if(total >= bottomConstraint){
					var i = Math.round(total / bottomConstraint); 
						var nearestMultiple = Math.floor((((parseInt(rowVal,10) + i) - 1) / i) * i);
						offSetSize = getTickSize() * (nearestMultiple / i);					
				}
				else {
					offSetSize = getTickSize() * (rowVal - 1);
				}
            }
        }
        return offSetSize;
    }
	
    function getTickSize(){
        var sFrame = top.iwp.statusFrame;
		var total = parseInt(top.iwp.bodyFrame.iwpinfo.found,10);
        
		if (total <= 1)
			return 0;
			
		var pixelVal = bottomConstraint / (total - 1);
      
        if (sFrame != null) {
            var obj = sFrame.document.getElementById('recnumField');
            if (obj != null) {
                var rowVal = parseInt(obj.value, 10);
                if (rowVal == 1) {
                    pixelVal = 0;
                }
                else if (rowVal > bottomConstraint) {
                        pixelVal = 1;
                    }
                if (pixelVal == bottomConstraint) {
                    pixelVal = bottomConstraint - 1;
                }	
            }
        }
	
		pixelVal = Math.floor(pixelVal*10)/10;
		var num = (new Number(pixelVal)).toFixed(1);
		pixelVal = parseFloat(num);
		return pixelVal;
    }
	
	
    // Adjust slider tickSize
    this.adjustSliderTickSize = function adjustSliderTickSize(){
		var tickSize = getTickSize();
        if (slider != null) {
            slider.thumb.setXConstraint(0, bottomConstraint, tickSize);
        }
    }
	
	// Move the slider one tick to the right
	this.goToNextSlider = function goToNextSlider(){
		this.setSliderValue();
	}
	
	// Move the slider one tick to the left
	this.goToPrevSlider = function goToPrevSlider(){
		this.setSliderValue();
	}
	
	// disable the slider (e.g. in edit mode)
	this.disableSlider = function disableSlider(){
		if (slider != null)
			slider.lock();
	}
	
	// enable the slider (e.g. in browse mode)
	this.enableSlider = function enableSlider(){
		if  (slider != null)
			slider.unlock();
	}
	
    this.hideMenu = function hideMenu()
	{
		recMenuButton.getMenu().hide();
		reqMenuButton.getMenu().hide();
		findMenuButton.getMenu().hide();
	}
	
	createFindToolBarButton = function()
	{
        //	handles the onclicks for the menu items
        var onMenuItemClick = function(p_sType, p_aArgs, p_oItem){
            
            switch (p_oItem.value) {
                case createfind:
                    createNewFind();
                    break;
                case modifylastfind:
                    top.iwp.goToRefind();
                    break;
            }
            
        };
		
		var onTitleChange = function(p_sType,p_aArgs) {
			return false;
		};
		
		var onShow = function(p_sType, p_aArgs) {
			var recordToolBox = top.iwp.statusFrame.document.getElementById("recordToolBox");
			recordToolBox.style.zIndex = 1;
			var extraToolBox = top.iwp.statusFrame.document.getElementById("extraToolBox");
			extraToolBox.style.zIndex = 100;
		};
        
        var aSplitButtonMenu = [{
            id: "createfind",
			text: top.iwp.strings.stat_lbl_newfind,
            value: createfind,
            onclick: {
                fn: onMenuItemClick
            }
        }, {
            id: "modifylastfind",
			text: top.iwp.strings.stat_lbl_refind,
            value: modifylastfind,
            onclick: {
                fn: onMenuItemClick
            }
        }];
        
        var createNewFind = function(){
            top.iwp.goToFind();
        };
       	
		findMenuButton.set("menu", aSplitButtonMenu);
		findMenuButton.subscribe("beforeTitleChange",onTitleChange);
		findMenuButton.subscribe("click",createNewFind);
		findMenuButton.getMenu().subscribe("show",onShow);
		findMenuButton.set("menualignment",["tl","tr"]);
    }
	
    createRecordToolBarButton = function(){
    
        var onShow = function(p_sTyle, p_aArgs) {
			var extraToolBox = top.iwp.statusFrame.document.getElementById("extraToolBox");
			extraToolBox.style.zIndex = 1;
			var recordToolBox = top.iwp.statusFrame.document.getElementById("recordToolBox");
			recordToolBox.style.zIndex = 100;
		};
		
		//	handles the onclicks for the menu items
        var onMenuItemClick = function(p_sType, p_aArgs, p_oItem){
            
			switch (p_oItem.value) {
                case duprec:
					top.iwp.duplicateRecord();
					break;
				case omitcurr:
                    top.iwp.omitSingleRecord();
                    break;
                case omitmulti:
                    top.iwp.omitMultiple();
                    break;
                case showomit:
                    top.iwp.findOmitted();
					break;
            }
            
        };
		
		var onTitleChange = function(p_sType,p_aArgs) {
			return false;
		};
        
        var aMenu = [{
            id: "duprec",
			text: top.iwp.strings.stat_lbl_dup,
            value: duprec,
            onclick: {
                fn: onMenuItemClick
			}
		},	{
            id:	"omitcurr",
			text: top.iwp.strings.stat_lbl_omit,
            value: omitcurr,
            onclick: {
                fn: onMenuItemClick
            }
        }, {
            id: "omitmulti",
			text: top.iwp.strings.stat_lbl_omitmulti,
            value: omitmulti,
            onclick: {
                fn: onMenuItemClick
            }
        }, {
            id: "showomit",
			text: top.iwp.strings.stat_lbl_showomit,
            value: showomit,
            onclick: {
                fn: onMenuItemClick
            }
        }];
        
        recMenuButton.set("menu", aMenu);
		recMenuButton.subscribe("beforeTitleChange",onTitleChange);
		recMenuButton.getMenu().subscribe("show",onShow);
		recMenuButton.set("menualignment",["tl","tr"]);
	}
	
	createRequestToolBarButton = function(){
    
        //	handles the onclicks for the menu items
        var onMenuItemClick = function(p_sType, p_aArgs, p_oItem){
            
            switch (p_oItem.value) {
                case dupreq:
					top.iwp.duplicateRequest();
					break;
				case efind:
                    top.iwp.performFind(1);
                    break;
                case cfind:
                    top.iwp.performFind(2);
                    break;
                case revertreq:
                    top.iwp.resetFindForm();
					break;
            }
            
        };
		
		var onTitleChange = function(p_sType,p_aArgs) {
			return false;
		};
        
        var aMenu = [{
            id: "dupreq",
			text: top.iwp.strings.stat_lbl_dupreq,
            value: dupreq,
            onclick: {
                fn: onMenuItemClick
			}
		},	{
            id:	"efind",
			text: top.iwp.strings.stat_lbl_efind,
            value: efind,
            onclick: {
                fn: onMenuItemClick
            }
        }, {
            id: "cfind",
			text: top.iwp.strings.stat_lbl_cfind,
            value: cfind,
            onclick: {
                fn: onMenuItemClick
            }
        }, {
            id: "revertreq",
			text: top.iwp.strings.stat_lbl_revertfind,
            value: revertreq,
            onclick: {
                fn: onMenuItemClick
            }
        }];
        
		reqMenuButton.set("menu", aMenu);
		reqMenuButton.subscribe("beforeTitleChange",onTitleChange);
		reqMenuButton.set("menualignment",["tl","tr"]);
		
	}
	
	var omitCheckChange = function(p_oEvent)
	{
			return false;
	};
	
	createOmitButtons = function (){
		
		var includeClick = function(){
			var includeButton = omitButtonGroup.getButton(include);
			includeButton.removeListener("beforeCheckedChange", omitCheckChange);
			omitButtonGroup.check(include);
			includeButton.addListener("beforeCheckedChange", omitCheckChange);
		};
        
        var omitClick = function(){
			var omitButton = omitButtonGroup.getButton(omit);
			omitButton.removeListener("beforeCheckedChange", omitCheckChange);
			omitButtonGroup.check(omit);
			omitButton.addListener("beforeCheckedChange", omitCheckChange);
        };
		
		omitButtonGroup.addButtons([{
            id: "includesplitbutton",
            checked: true,
			title: top.iwp.strings.stat_hlp_findinclude,
			label: top.iwp.strings.stat_lbl_find_include,
			onclick: {
                fn: includeClick
            }
        }, {
            id: "omitsplitbutton",
            title: top.iwp.strings.stat_hlp_findomit,
			label: top.iwp.strings.stat_lbl_find_omit,
			onclick: {
                fn: omitClick
            }
        }]);
				
		var includeButton = omitButtonGroup.getButton(include);
		includeButton.on("beforeCheckedChange", omitCheckChange);
		var omitButton = omitButtonGroup.getButton(omit);
		omitButton.on("beforeCheckedChange", omitCheckChange);
	}
    
    createViewButtons = function(){
        // Create a ButtonGroup without using existing markup
        
        var listClick = function(){
            top.iwp.goToView("list");
        };
        
        var formClick = function(){
            top.iwp.goToView("form");
        };
        
        var tableClick = function(){
            top.iwp.goToView("table");
        };
        
        viewButtonGroup.addButtons([{
            id: "formview",
			title: top.iwp.strings.stat_hlp_formview,
			label: "&nbsp&nbsp&nbsp&nbsp",
			onclick: {
                fn: formClick
            },
            checked: true
        }, {
            id: "listview",
			title: top.iwp.strings.stat_hlp_listview,
			label: "&nbsp&nbsp&nbsp&nbsp",
            onclick: {
                fn: listClick
            }
        }, {
            id: "tableview",
			title: top.iwp.strings.stat_hlp_tableview,
			label: "&nbsp&nbsp&nbsp&nbsp",
            onclick: {
                fn: tableClick
            }
        }]);
		
		var checkChange = function(p_oEvent)
		{
			var oldValue;
			var newValue = getCurrentView();
					
			if (viewButtonGroup.getButton(formview).get("checked"))
			{
				oldValue = formview;
			}
			else if (viewButtonGroup.getButton(listview).get("checked"))
			{
				oldValue = listview;
			}
			else
			{
				oldValue = tableview;
			}
			
			if (oldValue == newValue)
				return false;
		};
		
		var formviewButton = viewButtonGroup.getButton(formview);
		formviewButton.on("beforeCheckedChange", checkChange);
		var listviewButton = viewButtonGroup.getButton(listview);
		listviewButton.on("beforeCheckedChange", checkChange);
		var tableviewButton = viewButtonGroup.getButton(tableview);
		tableviewButton.on("beforeCheckedChange", checkChange);
	}
    
    
	this.selectViewButton = function selectViewButton(index){
        viewButtonGroup.check(index);
    }
    this.enableViewButton = function enableViewButton(index, isEnabled){
        viewButtonGroup.getButton(index).set("disabled", !isEnabled);
    }
	
	this.isOmitFindRequestSelected = function isOmitFindRequestSelected(){
		return omitButtonGroup.getButton(1).get("checked");
	}
	this.setOmitButtonSelected = function setOmitButtonSelected(isSelected){
		if (isSelected) {
			var omitButton = omitButtonGroup.getButton(omit);
			omitButton.removeListener("beforeCheckedChange");
			omitButtonGroup.check(omit);
			omitButton.addListener("beforeCheckedChange", omitCheckChange);
		}else{
			var includeButton = omitButtonGroup.getButton(include);
			includeButton.removeListener("beforeCheckedChange");
			omitButtonGroup.check(include);
			includeButton.addListener("beforeCheckedChange", omitCheckChange);
		}
	}
}

// Create Objects
if (top.yuisupport == null) 
    top.yuisupport = new YUISupport();
